Summary: Libraries for the Unidata network Common Data Form
Name: netcdf
Version: 4.3.2
Release: 1%{?dist}
License: NetCDF
Group: Applications/Engineering
URL: http://www.unidata.ucar.edu/software/netcdf/
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires: hdf5 >= 1.8.8
BuildRequires: libcurl-devel
BuildRequires: zlib-devel

Requires: hdf5 >= 1.8.8
Requires: libcurl
Requires: zlib

%description
NetCDF (network Common Data Form) is an interface for array-oriented 
data access and a freely-distributed collection of software libraries 
for C, Fortran, C++, and perl that provides an implementation of the 
interface.  The NetCDF library also defines a machine-independent 
format for representing scientific data.  Together, the interface, 
library, and format support the creation, access, and sharing of 
scientific data. The NetCDF software was developed at the Unidata 
Program Center in Boulder, Colorado.

NetCDF data is: 

   o Self-Describing: A NetCDF file includes information about the
     data it contains.

   o Network-transparent:  A NetCDF file is represented in a form that
     can be accessed by computers with different ways of storing
     integers, characters, and floating-point numbers.

   o Direct-access:  A small subset of a large dataset may be accessed
     efficiently, without first reading through all the preceding
     data.

   o Appendable:  Data can be appended to a NetCDF dataset along one
     dimension without copying the dataset or redefining its
     structure. The structure of a NetCDF dataset can be changed,
     though this sometimes causes the dataset to be copied.

   o Sharable:  One writer and multiple readers may simultaneously
     access the same NetCDF file.

%prep
%setup -q

%build
%configure
make
make check

%install
%make_install

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc COPYRIGHT README.md RELEASE_NOTES.md
%{_bindir}/*
%{_includedir}/*
%{_libdir}/*
%{_mandir}/man1/*
%{_mandir}/man3/*


%changelog
* Wed Aug  9 2014  <torutk@gmail.com> - 4.3.2-1 
- Initial build.

