/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4;

import info.gianlucacosta.easypmd4.StorageAreaService;
import info.gianlucacosta.easypmd4.SystemPropertiesService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.helios.io.Directory;
import info.gianlucacosta.helios.io.storagearea.DirectoryStorageArea;
import info.gianlucacosta.helios.io.storagearea.StorageArea;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultStorageAreaService
implements StorageAreaService {
    private static final Logger logger = Logger.getLogger(DefaultStorageAreaService.class.getName());
    private static final String STORAGE_DIR_NAME = ".EasyPmd4";
    private final SystemPropertiesService systemPropertiesService = Injector.lookup(SystemPropertiesService.class);
    private final StorageArea storageArea;

    public DefaultStorageAreaService() {
        DirectoryStorageArea tempStorageArea;
        Directory userHomeDir = this.systemPropertiesService.getUserHomeDir();
        if (userHomeDir != null) {
            Directory storageDir = new Directory((File)userHomeDir, STORAGE_DIR_NAME);
            tempStorageArea = new DirectoryStorageArea(storageDir);
        } else {
            tempStorageArea = null;
            logger.log(Level.SEVERE, "Cannot determine the home directory: the storage area will NOT be available");
        }
        this.storageArea = tempStorageArea;
    }

    @Override
    public StorageArea getStorageArea() {
        return this.storageArea;
    }
}

