/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4;

import info.gianlucacosta.easypmd4.SystemPropertiesService;
import info.gianlucacosta.helios.io.Directory;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultSystemPropertiesService
implements SystemPropertiesService {
    public String javaVersion;
    public Directory userHomeDir;

    private static String findJavaVersion() {
        String javaVersionProperty;
        Pattern versionPattern = Pattern.compile("(\\d\\.\\d).*");
        Matcher versionMatcher = versionPattern.matcher(javaVersionProperty = System.getProperty("java.version"));
        if (versionMatcher.matches()) {
            return versionMatcher.group(1);
        }
        return null;
    }

    private static Directory findUserHomeDir() {
        String userHomeString = System.getProperty("user.home");
        if (userHomeString == null) {
            return null;
        }
        File result = new File(userHomeString);
        if (result.exists() && result.isDirectory()) {
            return new Directory(result);
        }
        return null;
    }

    @Override
    public String getJavaVersion() {
        if (this.javaVersion == null) {
            this.javaVersion = DefaultSystemPropertiesService.findJavaVersion();
        }
        return this.javaVersion;
    }

    @Override
    public Directory getUserHomeDir() {
        if (this.userHomeDir == null) {
            this.userHomeDir = DefaultSystemPropertiesService.findUserHomeDir();
        }
        return this.userHomeDir;
    }
}

