/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide;

import java.util.Collection;
import org.openide.util.Lookup;

public class Injector {
    private static final Lookup lookup = Lookup.getDefault();

    private static Lookup getLookup() {
        return lookup;
    }

    public static <T> T lookup(Class<T> serviceClass) {
        Object result = Injector.getLookup().lookup(serviceClass);
        Injector.validateLookupResult(serviceClass, result);
        return (T)result;
    }

    public static <T> Collection<? extends T> lookupAll(Class<T> serviceClass) {
        Collection result = Injector.getLookup().lookupAll(serviceClass);
        Injector.validateLookupResult(serviceClass, result);
        return result;
    }

    private static void validateLookupResult(Class<?> serviceClass, Object lookupResult) {
        if (lookupResult == null && Injector.shouldThrowLookupExceptions(serviceClass)) {
            throw new IllegalArgumentException(String.format("Service '%s' not registered!", serviceClass.getSimpleName()));
        }
    }

    private static boolean shouldThrowLookupExceptions(Class<?> serviceClass) {
        TestService testService;
        return serviceClass == TestService.class || (testService = (TestService)lookup.lookup(TestService.class)) != null;
    }

    private Injector() {
    }

    public static class TestService {
    }
}

