/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.editor;

import info.gianlucacosta.easypmd4.ide.editor.AnnotationService;
import info.gianlucacosta.easypmd4.ide.editor.ScanMessageAnnotation;
import info.gianlucacosta.easypmd4.ide.editor.ScanMessageAnnotationList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.Line;

public class DefaultAnnotationService
implements AnnotationService {
    private final Map<FileObject, ScanMessageAnnotationList> attachedAnnotations = new HashMap<FileObject, ScanMessageAnnotationList>();
    private final Map<FileObject, FileChangeListener> registeredFileChangeListeners = new HashMap<FileObject, FileChangeListener>();

    @Override
    public void attachAnnotationsTo(DataObject dataObject, ScanMessageAnnotationList annotations) {
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.attachedAnnotations.containsKey(fileObject)) {
            throw new IllegalArgumentException("EasyPmd annotations have already been attached to this file.\nYou must detach them before attaching new ones.");
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        Line.Set lineSet = lineCookie.getLineSet();
        for (ScanMessageAnnotation annotation : annotations) {
            annotation.attach(lineSet);
        }
        this.attachedAnnotations.put(fileObject, annotations);
        this.registerFileEventHandlers(fileObject);
    }

    private void registerFileEventHandlers(final FileObject fileObject) {
        FileChangeAdapter fileChangeListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent ev) {
                DefaultAnnotationService.this.detachAnnotationsFrom(fileObject);
            }

            public void fileDeleted(FileEvent ev) {
                DefaultAnnotationService.this.detachAnnotationsFrom(fileObject);
            }
        };
        fileObject.addFileChangeListener((FileChangeListener)fileChangeListener);
        this.registeredFileChangeListeners.put(fileObject, (FileChangeListener)fileChangeListener);
    }

    @Override
    public void detachAnnotationsFrom(FileObject fileObject) {
        ScanMessageAnnotationList fileAnnotations = this.attachedAnnotations.get(fileObject);
        if (fileAnnotations == null) {
            return;
        }
        for (Annotation annotation : fileAnnotations) {
            annotation.detach();
        }
        this.attachedAnnotations.remove(fileObject);
        this.unregisterFileEventHandlers(fileObject);
    }

    private void unregisterFileEventHandlers(FileObject fileObject) {
        FileChangeListener fileChangeListener = this.registeredFileChangeListeners.get(fileObject);
        fileObject.removeFileChangeListener(fileChangeListener);
        this.registeredFileChangeListeners.remove(fileObject);
    }

    @Override
    public void detachAllAnnotations() {
        ArrayList<FileObject> fileObjects = new ArrayList<FileObject>(this.attachedAnnotations.keySet());
        for (FileObject fileObject : fileObjects) {
            this.detachAnnotationsFrom(fileObject);
        }
    }
}

