/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.InvalidOptionsException;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.ide.options.OptionsVerifier;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfiguration;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfigurationRepository;
import info.gianlucacosta.helios.beans.events.EventListener;
import info.gianlucacosta.helios.beans.events.TriggerEvent;
import info.gianlucacosta.helios.beans.events.TriggerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultOptionsService
implements OptionsService {
    private static final Logger logger = Logger.getLogger(DefaultOptionsService.class.getName());
    private final TriggerEvent optionsChangedEvent = new TriggerEvent();
    private final Lock readLock;
    private final Lock writeLock;
    private final Collection<OptionsVerifier> optionsVerifiers = new ArrayList<OptionsVerifier>();
    private Options options;

    public DefaultOptionsService() {
        ReentrantReadWriteLock optionsLock = new ReentrantReadWriteLock();
        this.readLock = optionsLock.readLock();
        this.writeLock = optionsLock.writeLock();
        ProfileConfigurationRepository profileConfigurationRepository = Injector.lookup(ProfileConfigurationRepository.class);
        ProfileConfiguration profileConfiguration = profileConfigurationRepository.getProfileConfiguration();
        this.options = profileConfiguration.getActiveOptions();
    }

    @Override
    public void addOptionsChangedListener(TriggerListener listener) {
        this.writeLock.lock();
        try {
            this.optionsChangedEvent.addListener((EventListener)listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeOptionsChangedListener(TriggerListener listener) {
        this.writeLock.lock();
        try {
            this.optionsChangedEvent.removeListener((EventListener)listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Options getOptions() {
        this.readLock.lock();
        try {
            Options options = this.options;
            return options;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setOptions(Options options) {
        this.writeLock.lock();
        try {
            Options oldOptions = this.options;
            this.options = options;
            if (!options.equals(oldOptions)) {
                logger.log(Level.INFO, "Options changed!");
                this.optionsChangedEvent.fire();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addOptionsVerifier(OptionsVerifier optionsVerifier) {
        this.optionsVerifiers.add(optionsVerifier);
    }

    @Override
    public void removeOptionsVerifier(OptionsVerifier optionsVerifier) {
        this.optionsVerifiers.remove(optionsVerifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyOptions(Options options) throws InvalidOptionsException {
        this.writeLock.lock();
        try {
            for (OptionsVerifier optionsVerifier : this.optionsVerifiers) {
                optionsVerifier.verifyOptions(options);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

