/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.EasyPmdPanel;
import info.gianlucacosta.easypmd4.ide.options.InvalidOptionsException;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.ide.options.OptionsVerifier;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfiguration;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfigurationRepository;
import info.gianlucacosta.easypmd4.pmdscanner.PmdScanner;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class EasyPmdOptionsPanelController
extends OptionsPanelController {
    private static final String EASY_PMD_OPTIONS_NAME_IN_EVENT = "EASYPMD_OPTIONS";
    private final EasyPmdPanel panel = new EasyPmdPanel();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private final ProfileConfigurationRepository profileConfigurationRepository = Injector.lookup(ProfileConfigurationRepository.class);
    private final OptionsService optionsService = Injector.lookup(OptionsService.class);
    private boolean optionsChanged;

    public EasyPmdOptionsPanelController() {
        this.optionsService.addOptionsVerifier(new OptionsVerifier(){

            @Override
            public void verifyOptions(Options options) throws InvalidOptionsException {
                try {
                    new PmdScanner(options);
                }
                catch (RuntimeException ex) {
                    throw new InvalidOptionsException(ex);
                }
            }
        });
    }

    public void update() {
        ProfileConfiguration profileConfiguration = this.profileConfigurationRepository.getProfileConfiguration();
        this.panel.setProfileConfiguration(profileConfiguration);
    }

    public void applyChanges() {
        ProfileConfiguration profileConfiguration = this.panel.getProfileConfiguration();
        this.profileConfigurationRepository.saveProfileConfiguration(profileConfiguration);
        Options oldOptions = this.optionsService.getOptions();
        Options newOptions = profileConfiguration.getActiveOptions();
        this.optionsService.setOptions(newOptions);
        if (!newOptions.equals(oldOptions)) {
            this.pcs.firePropertyChange(EASY_PMD_OPTIONS_NAME_IN_EVENT, oldOptions, newOptions);
        }
    }

    public void cancel() {
    }

    public boolean isValid() {
        try {
            Options activeOptions = this.panel.getProfileConfiguration().getActiveOptions();
            this.optionsService.verifyOptions(activeOptions);
            return true;
        }
        catch (InvalidOptionsException ex) {
            return false;
        }
    }

    public boolean isChanged() {
        return this.optionsChanged;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("info.gianlucacosta.easypmd4.options");
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }
}

