/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.helios.regex.CompositeRegex;
import java.io.Serializable;

public class PathFilteringOptions
implements Serializable {
    private final CompositeRegex includedPathCompositeRegex;
    private final CompositeRegex excludedPathCompositeRegex;

    public PathFilteringOptions(CompositeRegex includedPathCompositeRegex, CompositeRegex excludedPathCompositeRegex) {
        this.includedPathCompositeRegex = includedPathCompositeRegex;
        this.excludedPathCompositeRegex = excludedPathCompositeRegex;
    }

    public CompositeRegex getExcludedPathCompositeRegex() {
        return this.excludedPathCompositeRegex;
    }

    public CompositeRegex getIncludedPathCompositeRegex() {
        return this.includedPathCompositeRegex;
    }

    private boolean isScanOnlySomePaths() {
        return !this.includedPathCompositeRegex.getSubRegexes().isEmpty();
    }

    private boolean isExcludeSomePaths() {
        return !this.excludedPathCompositeRegex.getSubRegexes().isEmpty();
    }

    public boolean isPathValid(String path) {
        if (this.isScanOnlySomePaths() && !this.includedPathCompositeRegex.matches(path)) {
            return false;
        }
        return !this.isExcludeSomePaths() || !this.excludedPathCompositeRegex.matches(path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathFilteringOptions)) {
            return false;
        }
        PathFilteringOptions other = (PathFilteringOptions)obj;
        return this.includedPathCompositeRegex.equals((Object)other.includedPathCompositeRegex) && this.excludedPathCompositeRegex.equals((Object)other.excludedPathCompositeRegex);
    }

    public int hashCode() {
        return this.includedPathCompositeRegex.hashCode() + this.excludedPathCompositeRegex.hashCode();
    }
}

