/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options.profiles;

import info.gianlucacosta.easypmd4.ide.options.profiles.Profile;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileException;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileMap;
import info.gianlucacosta.helios.beans.events.EventListener;
import info.gianlucacosta.helios.beans.events.TriggerEvent;
import info.gianlucacosta.helios.beans.events.TriggerListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultProfileMap
implements ProfileMap,
Serializable {
    private final TriggerEvent profileNamesChangedEvent = new TriggerEvent();
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();

    @Override
    public void setProfile(String profileName, Profile profile) throws ProfileException {
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        boolean profileNamesChanged = !this.profiles.containsKey(profileName);
        this.profiles.put(profileName, profile);
        if (profileNamesChanged) {
            this.profileNamesChangedEvent.fire();
        }
    }

    @Override
    public Collection<String> getProfileNames() {
        return this.profiles.keySet();
    }

    @Override
    public Profile getProfile(String profileName) {
        return this.profiles.get(profileName);
    }

    @Override
    public void duplicateProfile(String sourceName, String targetName) throws ProfileException {
        if (this.profiles.containsKey(targetName)) {
            throw new ProfileException(String.format("A profile named '%s' already exists", targetName));
        }
        Profile sourceProfile = this.profiles.get(sourceName);
        if (sourceProfile == null) {
            throw new IllegalArgumentException();
        }
        Profile targetProfile = sourceProfile.clone();
        this.profiles.put(targetName, targetProfile);
        this.profileNamesChangedEvent.fire();
    }

    @Override
    public void renameProfile(String oldName, String newName) throws ProfileException {
        if (oldName.equals(newName)) {
            return;
        }
        if (this.profiles.containsKey(newName)) {
            throw new ProfileException(String.format("A profile named '%s' already exists", newName));
        }
        Profile profile = this.profiles.get(oldName);
        if (profile == null) {
            throw new IllegalArgumentException();
        }
        this.profiles.put(newName, profile);
        this.profiles.remove(oldName);
        this.profileNamesChangedEvent.fire();
    }

    @Override
    public void removeProfile(String name) throws ProfileException {
        if (!this.profiles.containsKey(name)) {
            return;
        }
        this.profiles.remove(name);
        this.profileNamesChangedEvent.fire();
    }

    @Override
    public void addProfileNamesChangedListener(TriggerListener listener) {
        this.profileNamesChangedEvent.addListener((EventListener)listener);
    }

    @Override
    public void removeProfileNamesChangedListener(TriggerListener listener) {
        this.profileNamesChangedEvent.removeListener((EventListener)listener);
    }

    @Override
    public boolean profileNameExists(String profileName) {
        return this.profiles.containsKey(profileName);
    }
}

