/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.pmdscanner.LanguageVersionParser;
import info.gianlucacosta.easypmd4.pmdscanner.PmdBasedClassLoader;
import info.gianlucacosta.easypmd4.pmdscanner.PmdScannerStrategy;
import info.gianlucacosta.easypmd4.pmdscanner.ScanError;
import info.gianlucacosta.easypmd4.pmdscanner.ScanMessageList;
import info.gianlucacosta.easypmd4.pmdscanner.ScanViolation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.dfa.report.ReportTree;

class LinkedPmdScanningStrategy
implements PmdScannerStrategy {
    private final LanguageVersionParser languageVersionParser = Injector.lookup(LanguageVersionParser.class);
    private final PMD pmd;
    private final RuleSets ruleSets;
    private final String sourceFileEncoding;

    public LinkedPmdScanningStrategy(Options options) {
        PmdBasedClassLoader pmdBasedClassLoader = new PmdBasedClassLoader(options.getAdditionalClassPathUrls());
        RuleSetFactory rulesetFactory = new RuleSetFactory();
        String ruleSetsString = this.buildRuleSetsString(options.getRuleSets());
        try {
            rulesetFactory.setClassLoader((ClassLoader)pmdBasedClassLoader);
            this.ruleSets = rulesetFactory.createRuleSets(ruleSetsString);
        }
        catch (RuleSetNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        LanguageVersion languageVersion = this.languageVersionParser.parse(options.getTargetJavaVersion());
        this.sourceFileEncoding = options.getSourceFileEncoding();
        this.pmd = new PMD();
        PMDConfiguration pmdConfiguration = this.pmd.getConfiguration();
        pmdConfiguration.setDefaultLanguageVersion(languageVersion);
        pmdConfiguration.setSuppressMarker(options.getSuppressMarker());
    }

    private String buildRuleSetsString(Collection<String> ruleSets) {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = ruleSets.iterator();
        while (iterator.hasNext()) {
            String ruleSet = iterator.next();
            result.append(ruleSet);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    @Override
    public ScanMessageList scanFile(File file) {
        String filePath = file.getAbsolutePath();
        Report report = new Report();
        RuleContext ruleContext = new RuleContext();
        ruleContext.setReport(report);
        ruleContext.setSourceCodeFilename(filePath);
        ScanMessageList scanMessages = new ScanMessageList();
        try {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filePath), this.sourceFileEncoding);){
                this.pmd.getSourceCodeProcessor().processSourceCode((Reader)reader, this.ruleSets, ruleContext);
            }
            ReportTree violationTree = report.getViolationTree();
            for (RuleViolation violation : violationTree) {
                scanMessages.add(new ScanViolation(violation));
            }
        }
        catch (IOException | PMDException ex) {
            scanMessages.add(new ScanError((Exception)ex));
        }
        return scanMessages;
    }
}

