/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.pmdscanner.CacheBasedLinkedPmdScanningStrategy;
import info.gianlucacosta.easypmd4.pmdscanner.LinkedPmdScanningStrategy;
import info.gianlucacosta.easypmd4.pmdscanner.NoOpPmdScannerStrategy;
import info.gianlucacosta.easypmd4.pmdscanner.PmdScannerStrategy;
import info.gianlucacosta.easypmd4.pmdscanner.ScanError;
import info.gianlucacosta.easypmd4.pmdscanner.ScanMessageList;
import java.io.File;

public class PmdScanner {
    private final PmdScannerStrategy strategy;

    public PmdScanner(Options options) {
        if (options.getRuleSets().isEmpty()) {
            this.strategy = new NoOpPmdScannerStrategy();
            return;
        }
        this.strategy = options.isUseScanMessagesCache() ? new CacheBasedLinkedPmdScanningStrategy(options) : new LinkedPmdScanningStrategy(options);
    }

    public ScanMessageList scanFile(File file) {
        try {
            return this.strategy.scanFile(file);
        }
        catch (RuntimeException ex) {
            ScanMessageList result = new ScanMessageList();
            result.add(new ScanError(ex));
            return result;
        }
    }
}

