/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.easypmd4.ThrowableExtensions;
import info.gianlucacosta.easypmd4.pmdscanner.ScanMessage;

class ScanError
implements ScanMessage {
    private static final int MAX_STACK_TRACE_STRING_LENGTH = 2000;
    private static final String ELLIPSIS_STRING = "\n<...>";
    private final String stackTraceString;
    private final String message;

    public ScanError(Exception exception) {
        String fullStackTraceString = ThrowableExtensions.getStackTraceString(exception);
        this.stackTraceString = fullStackTraceString.length() < 2000 ? fullStackTraceString : fullStackTraceString.substring(0, 2000 - ELLIPSIS_STRING.length() - 1) + ELLIPSIS_STRING;
        this.message = ThrowableExtensions.getNonEmptyMessage(exception);
    }

    @Override
    public String getAnnotationText() {
        return String.format(this.stackTraceString, new Object[0]);
    }

    @Override
    public int getLineNumber() {
        return 1;
    }

    @Override
    public String getTaskText() {
        return this.message;
    }

    @Override
    public String getTaskType() {
        return "info.gianlucacosta.easypmd4.ide.tasklist.error";
    }

    @Override
    public String getAnnotationType() {
        return "info.gianlucacosta.easypmd4.annotations.ErrorAnnotation";
    }

    @Override
    public boolean isShowableInGuardedSections() {
        return true;
    }
}

