/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.pmdscanner.ScanMessage;
import net.sourceforge.pmd.RuleViolation;

class ScanViolation
implements ScanMessage {
    private static final String ANNOTATION_TOKEN_SEPARATOR = "\n";
    private static final String TASK_TOKEN_SEPARATOR = " ";
    private final int lineNumber;
    private final String description;
    private final String ruleName;
    private final String ruleSetName;
    private transient String taskText;
    private transient String annotationText;

    public ScanViolation(RuleViolation ruleViolation) {
        this.lineNumber = ruleViolation.getBeginLine();
        this.description = ruleViolation.getDescription();
        this.ruleName = ruleViolation.getRule().getName();
        this.ruleSetName = ruleViolation.getRule().getRuleSetName();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    private void verifyTransientFields() {
        if (this.taskText != null && this.annotationText != null) {
            return;
        }
        OptionsService optionsService = Injector.lookup(OptionsService.class);
        Options options = optionsService.getOptions();
        this.taskText = this.formatViolationComponents(TASK_TOKEN_SEPARATOR, options.isShowDescriptionInTasks(), options.isShowRuleInTasks(), options.isShowRuleSetInTasks());
        this.annotationText = this.formatViolationComponents(ANNOTATION_TOKEN_SEPARATOR, true, true, true);
    }

    @Override
    public String getTaskText() {
        this.verifyTransientFields();
        return this.taskText;
    }

    @Override
    public String getTaskType() {
        return "info.gianlucacosta.easypmd4.ide.tasklist.violation";
    }

    @Override
    public String getAnnotationText() {
        this.verifyTransientFields();
        return this.annotationText;
    }

    @Override
    public String getAnnotationType() {
        return "info.gianlucacosta.easypmd4.annotations.ViolationAnnotation";
    }

    private String formatViolationComponents(String separator, boolean showDescription, boolean showRuleName, boolean showRuleSetName) {
        StringBuilder resultBuilder = new StringBuilder();
        if (showDescription) {
            resultBuilder.append(this.description);
        }
        if (showRuleName) {
            if (resultBuilder.length() > 0) {
                resultBuilder.append(separator);
            }
            resultBuilder.append("Rule: " + this.ruleName);
        }
        if (showRuleSetName) {
            if (resultBuilder.length() > 0) {
                resultBuilder.append(separator);
            }
            resultBuilder.append("Rule set: " + this.ruleSetName);
        }
        return resultBuilder.toString();
    }

    @Override
    public boolean isShowableInGuardedSections() {
        return false;
    }
}

