/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide;

import info.gianlucacosta.easypmd4.PluginInfoService;
import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.helios.application.io.CommonQuestionOutcome;
import javax.swing.JOptionPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DefaultDialogService
implements DialogService {
    private final PluginInfoService pluginInfoService = Injector.lookup(PluginInfoService.class);

    private void showMessageBox(String message, int kind) {
        NotifyDescriptor.Message messageDescriptor = new NotifyDescriptor.Message((Object)message, kind);
        messageDescriptor.setTitle(this.pluginInfoService.getName());
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)messageDescriptor);
    }

    @Override
    public void showInfo(String message) {
        this.showMessageBox(message, 1);
    }

    @Override
    public void showWarning(String message) {
        this.showMessageBox(message, 2);
    }

    @Override
    public void showError(String message) {
        this.showMessageBox(message, 0);
    }

    @Override
    public String askForString(String message) {
        return JOptionPane.showInputDialog(null, message, this.pluginInfoService.getName(), 3);
    }

    @Override
    public String askForString(String message, String defaultValue) {
        return JOptionPane.showInputDialog(null, message, defaultValue);
    }

    @Override
    public CommonQuestionOutcome askYesNoQuestion(String message) {
        int dialogResult = JOptionPane.showConfirmDialog(null, message, this.pluginInfoService.getName(), 0, 3);
        switch (dialogResult) {
            case 0: {
                return CommonQuestionOutcome.YES;
            }
            case 1: {
                return CommonQuestionOutcome.NO;
            }
        }
        throw new IllegalStateException();
    }
}

