/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide;

import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.editor.AnnotationService;
import info.gianlucacosta.easypmd4.ide.editor.GuardedSectionsAnalyzer;
import info.gianlucacosta.easypmd4.ide.editor.ScanMessageAnnotationList;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.ide.tasklist.ScanMessageTaskList;
import info.gianlucacosta.easypmd4.pmdscanner.PmdScanner;
import info.gianlucacosta.easypmd4.pmdscanner.ScanMessageList;
import info.gianlucacosta.helios.beans.events.TriggerListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class IdeScanner
extends FileTaskScanner {
    private static final Logger logger = Logger.getLogger(IdeScanner.class.getName());
    private static final String OPTIONS_PATH = "Advanced/info.gianlucacosta.easypmd4";
    private final AnnotationService annotationService;
    private final DialogService dialogService = Injector.lookup(DialogService.class);
    private final OptionsService optionsService;
    private FileTaskScanner.Callback callback;
    private PmdScanner pmdScanner;
    private Options options;
    private final Lock readOptionsLock;
    private final Lock writeOptionsLock;

    public IdeScanner(String displayName, String description, String optionsPath) {
        super(displayName, description, optionsPath);
        this.annotationService = Injector.lookup(AnnotationService.class);
        this.optionsService = Injector.lookup(OptionsService.class);
        ReentrantReadWriteLock optionsLock = new ReentrantReadWriteLock();
        this.readOptionsLock = optionsLock.readLock();
        this.writeOptionsLock = optionsLock.writeLock();
        this.options = this.optionsService.getOptions();
        try {
            this.pmdScanner = new PmdScanner(this.options);
        }
        catch (RuntimeException ex) {
            this.showScannerConfigurationException(ex);
        }
        this.optionsService.addOptionsChangedListener(new TriggerListener(){

            public void onTriggered() {
                logger.log(Level.INFO, "The options have changed: reinitializing the IDE scanner");
                IdeScanner.this.writeOptionsLock.lock();
                try {
                    IdeScanner.this.annotationService.detachAllAnnotations();
                    IdeScanner.this.options = IdeScanner.this.optionsService.getOptions();
                    try {
                        IdeScanner.this.pmdScanner = new PmdScanner(IdeScanner.this.options);
                    }
                    catch (RuntimeException ex) {
                        IdeScanner.this.pmdScanner = null;
                        IdeScanner.this.showScannerConfigurationException(ex);
                    }
                    if (IdeScanner.this.callback != null) {
                        IdeScanner.this.callback.refreshAll();
                    }
                }
                finally {
                    IdeScanner.this.writeOptionsLock.unlock();
                }
            }
        });
    }

    private void showScannerConfigurationException(Exception ex) {
        logger.log(Level.WARNING, "Configuration exception for EasyPmd:\n%s", ex);
        this.dialogService.showWarning(String.format("Could not run EasyPmd because of configuration errors:\n\t%s (%s)", ex.getMessage(), ex.getClass().getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends Task> scan(FileObject fileObject) {
        if (this.pmdScanner == null) {
            return new ScanMessageTaskList();
        }
        this.readOptionsLock.lock();
        try {
            GuardedSectionsAnalyzer guardedSectionsAnalyzer;
            Set<Integer> guardedPmdLineNumbers;
            DataObject dataObject;
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null || !file.isFile()) {
                ScanMessageTaskList scanMessageTaskList = new ScanMessageTaskList();
                return scanMessageTaskList;
            }
            this.annotationService.detachAnnotationsFrom(fileObject);
            String filePath = file.getPath();
            if (!this.options.getPathFilteringOptions().isPathValid(filePath)) {
                ScanMessageTaskList scanMessageTaskList = new ScanMessageTaskList();
                return scanMessageTaskList;
            }
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            ScanMessageList scanMessages = this.pmdScanner.scanFile(file);
            if (!this.options.isShowAllMessagesInGuardedSections() && !(guardedPmdLineNumbers = (guardedSectionsAnalyzer = new GuardedSectionsAnalyzer(dataObject)).getGuardedLineNumbers()).isEmpty()) {
                scanMessages = scanMessages.filterOutGuardedSections(guardedPmdLineNumbers);
            }
            ScanMessageTaskList tasks = new ScanMessageTaskList(fileObject, scanMessages);
            if (this.options.isShowAnnotationsInEditor()) {
                ScanMessageAnnotationList annotations = new ScanMessageAnnotationList(scanMessages);
                this.annotationService.attachAnnotationsTo(dataObject, annotations);
            }
            ScanMessageTaskList scanMessageTaskList = tasks;
            return scanMessageTaskList;
        }
        finally {
            this.readOptionsLock.unlock();
        }
    }

    public void attach(FileTaskScanner.Callback callback) {
        logger.log(Level.INFO, String.format("Attaching callback: %s", callback));
        this.callback = callback;
        if (callback == null) {
            this.annotationService.detachAllAnnotations();
        } else {
            callback.refreshAll();
        }
    }

    public static IdeScanner create() throws ParserConfigurationException {
        ResourceBundle bundle = NbBundle.getBundle(IdeScanner.class);
        return new IdeScanner(bundle.getString("Filter_DisplayName"), bundle.getString("Filter_Description"), OPTIONS_PATH);
    }
}

