/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.editor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public class GuardedSectionsAnalyzer {
    private final Set<Integer> guardedLineNumbers = new HashSet<Integer>();

    public GuardedSectionsAnalyzer(DataObject dataObject) {
        try {
            EditorCookie documentCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            StyledDocument document = documentCookie.openDocument();
            this.initialize(document);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public GuardedSectionsAnalyzer(StyledDocument document) {
        this.initialize(document);
    }

    private void initialize(StyledDocument document) {
        try {
            String fileContents = document.getText(0, document.getLength());
            if (fileContents.isEmpty()) {
                return;
            }
            GuardedSectionManager guardedSectionManager = GuardedSectionManager.getInstance((StyledDocument)document);
            if (guardedSectionManager == null) {
                return;
            }
            Iterable guardedSections = guardedSectionManager.getGuardedSections();
            if (!guardedSections.iterator().hasNext()) {
                return;
            }
            int lastLineSeparatorIndex = -1;
            int lineNumber = 1;
            while (true) {
                int lineStartIndex = lastLineSeparatorIndex + 1;
                Position lineStartPosition = document.createPosition(lineStartIndex);
                for (GuardedSection guardedSection : guardedSections) {
                    if (!guardedSection.contains(lineStartPosition, true)) continue;
                    this.guardedLineNumbers.add(lineNumber);
                    break;
                }
                if ((lastLineSeparatorIndex = fileContents.indexOf("\n", lastLineSeparatorIndex + 1)) != -1) {
                    ++lineNumber;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Set<Integer> getGuardedLineNumbers() {
        return Collections.unmodifiableSet(this.guardedLineNumbers);
    }
}

