/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.helios.swing.dialogs.JarFileChooser;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionJList;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AdditionalClasspathPanel
extends JPanel {
    private static final JarFileChooser pathChooser = new JarFileChooser("Select path...");
    private final AdvancedSelectionListModel<URL> additionalClasspathModel = new AdvancedSelectionListModel();
    private final DialogService dialogService;
    private JButton addCustomUrlButton;
    private JButton addJarButton;
    private AdvancedSelectionJList additionalClasspathList;
    private JScrollPane additionalClasspathScrollPane;
    private JPanel buttonsPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;

    public AdditionalClasspathPanel() {
        this.initComponents();
        this.dialogService = Injector.lookup(DialogService.class);
        this.additionalClasspathList.setModel(this.additionalClasspathModel);
    }

    private void initComponents() {
        this.additionalClasspathScrollPane = new JScrollPane();
        this.additionalClasspathList = new AdvancedSelectionJList();
        this.buttonsPanel = new JPanel();
        this.addJarButton = new JButton();
        this.addCustomUrlButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.additionalClasspathScrollPane.setViewportView((Component)this.additionalClasspathList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.additionalClasspathScrollPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addJarButton.setText(NbBundle.getMessage(AdditionalClasspathPanel.class, (String)"AdditionalClasspathPanel.addJarButton.text_1"));
        this.addJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalClasspathPanel.this.addJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.addJarButton, gridBagConstraints);
        this.addCustomUrlButton.setText(NbBundle.getMessage(AdditionalClasspathPanel.class, (String)"AdditionalClasspathPanel.addCustomUrlButton.text_1"));
        this.addCustomUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalClasspathPanel.this.addCustomUrlButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.addCustomUrlButton, gridBagConstraints);
        this.moveUpButton.setText(NbBundle.getMessage(AdditionalClasspathPanel.class, (String)"AdditionalClasspathPanel.moveUpButton.text_1"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalClasspathPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setText(NbBundle.getMessage(AdditionalClasspathPanel.class, (String)"AdditionalClasspathPanel.moveDownButton.text_1"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalClasspathPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getMessage(AdditionalClasspathPanel.class, (String)"AdditionalClasspathPanel.removeButton.text_1"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalClasspathPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        URL selectedJarUrl;
        pathChooser.setSelectedFile(new File(""));
        if (pathChooser.showOpenDialog(null) != 0) {
            return;
        }
        File selectedFile = pathChooser.getSelectedFile();
        try {
            selectedJarUrl = Utilities.toURI((File)selectedFile).toURL();
        }
        catch (MalformedURLException ex) {
            this.dialogService.showWarning("Error: invalid file path");
            return;
        }
        this.additionalClasspathModel.addElement((Object)selectedJarUrl);
    }

    private void addCustomUrlButtonActionPerformed(ActionEvent evt) {
        URL newPathUrl;
        String newPathString = this.dialogService.askForString("Path URL:");
        if (newPathString == null) {
            return;
        }
        newPathString = newPathString.trim();
        try {
            newPathUrl = new URL(newPathString);
        }
        catch (MalformedURLException ex) {
            this.dialogService.showWarning("Invalid URL");
            return;
        }
        this.additionalClasspathModel.addElement((Object)newPathUrl);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.additionalClasspathList.moveUpSelection();
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.additionalClasspathList.moveDownSelection();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.additionalClasspathList.removeSelection();
    }

    public Collection<URL> getAdditionalClassPathUrls() {
        return this.additionalClasspathModel.getItems();
    }

    public void setAdditionalClasspathUrls(Collection<URL> additionalClasspathUrls) {
        this.additionalClasspathModel.setItems(additionalClasspathUrls);
    }
}

