/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.SystemPropertiesService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.DefaultOptions;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsFactory;
import info.gianlucacosta.easypmd4.ide.options.PathFilteringOptions;
import info.gianlucacosta.easypmd4.pmdscanner.LanguageVersionParser;
import info.gianlucacosta.easypmd4.pmdscanner.StandardRuleSetsCatalog;
import info.gianlucacosta.helios.regex.CompositeRegex;
import info.gianlucacosta.helios.regex.OsSpecificPathCompositeRegex;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultOptionsFactory
implements OptionsFactory {
    private static final Logger logger = Logger.getLogger(DefaultOptionsFactory.class.getName());
    private static final String defaultJavaLanguageVersion = "1.7";
    private final StandardRuleSetsCatalog standardRulesetsCatalog = Injector.lookup(StandardRuleSetsCatalog.class);
    private final SystemPropertiesService systemPropertiesService = Injector.lookup(SystemPropertiesService.class);
    private final LanguageVersionParser languageVersionParser = Injector.lookup(LanguageVersionParser.class);

    @Override
    public Options createDefaultOptions() {
        DefaultOptions result = new DefaultOptions();
        String retrievedJavaVersion = this.systemPropertiesService.getJavaVersion();
        String javaVersion = retrievedJavaVersion != null ? retrievedJavaVersion : defaultJavaLanguageVersion;
        try {
            this.languageVersionParser.parse(javaVersion);
        }
        catch (IllegalArgumentException ex) {
            javaVersion = defaultJavaLanguageVersion;
        }
        result.setTargetJavaVersion(javaVersion);
        result.setSourceFileEncoding("utf-8");
        result.setSuppressMarker("NOPMD");
        result.setAdditionalClassPathUrls(new ArrayList<URL>());
        String[] suggestedDefaultRuleSetFileNames = new String[]{"rulesets/java/basic.xml", "rulesets/java/imports.xml", "rulesets/java/unusedcode.xml"};
        ArrayList<String> defaultRuleSets = new ArrayList<String>();
        for (String ruleSetFileName : suggestedDefaultRuleSetFileNames) {
            if (this.standardRulesetsCatalog.containsFileName(ruleSetFileName)) {
                defaultRuleSets.add(ruleSetFileName);
                continue;
            }
            logger.log(Level.WARNING, String.format("The standard ruleset '%s' was not found", ruleSetFileName));
        }
        result.setRuleSets(defaultRuleSets);
        result.setUseScanMessagesCache(true);
        result.setShowAnnotationsInEditor(true);
        result.setShowDescriptionInTasks(true);
        result.setShowRuleInTasks(false);
        result.setShowRuleSetInTasks(false);
        result.setShowAllMessagesInGuardedSections(false);
        result.setPathFilteringOptions(new PathFilteringOptions((CompositeRegex)new OsSpecificPathCompositeRegex(new String[]{"^.*\\.java$"}), (CompositeRegex)new OsSpecificPathCompositeRegex(new String[0])));
        return result;
    }
}

