/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.AdditionalClasspathPanel;
import info.gianlucacosta.easypmd4.ide.options.DefaultOptions;
import info.gianlucacosta.easypmd4.ide.options.InvalidOptionsException;
import info.gianlucacosta.easypmd4.ide.options.Options;
import info.gianlucacosta.easypmd4.ide.options.OptionsFactory;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.ide.options.PathFilteringOptions;
import info.gianlucacosta.easypmd4.ide.options.PathFilteringPanel;
import info.gianlucacosta.easypmd4.ide.options.RuleSetsPanel;
import info.gianlucacosta.easypmd4.ide.options.profiles.DefaultProfile;
import info.gianlucacosta.easypmd4.ide.options.profiles.DefaultProfileConfiguration;
import info.gianlucacosta.easypmd4.ide.options.profiles.Profile;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfiguration;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileException;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileMap;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.ScanMessagesCache;
import info.gianlucacosta.helios.application.io.CommonQuestionOutcome;
import info.gianlucacosta.helios.beans.events.TriggerListener;
import info.gianlucacosta.helios.regex.CompositeRegex;
import info.gianlucacosta.helios.regex.OsSpecificPathCompositeRegex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class EasyPmdPanel
extends JPanel {
    private final DialogService dialogService;
    private final OptionsFactory optionsFactory;
    private final OptionsService optionsService = Injector.lookup(OptionsService.class);
    private final ScanMessagesCache scanMessagesCache = Injector.lookup(ScanMessagesCache.class);
    private ProfileMap profiles;
    private String activeProfileName;
    private ActionListener profileComboActionListener;
    private boolean refillingProfileCombo;
    private AdditionalClasspathPanel additionalClasspathPanel;
    private JPanel cachePanel;
    private JButton clearScanMessagesCacheButton;
    private JButton duplicateProfileButton;
    private JPanel generalPanel;
    private JPanel jPanel1;
    private JPanel mainAdditionalClasspathPanel;
    private JPanel mainPathFilteringPanel;
    private JPanel mainRuleSetsPanel;
    private JTabbedPane optionsTabbedPane;
    private PathFilteringPanel pathFilteringPanel;
    private JScrollPane pathFilteringScrollPane;
    private JComboBox profileCombo;
    private JLabel profileLabel;
    private JButton removeProfileButton;
    private JButton renameProfileButton;
    private JPanel reportingPanel;
    private JButton resetSettingsButton;
    private RuleSetsPanel ruleSetsPanel;
    private JCheckBox showAllMessagesInGuardedSectionsCheckBox;
    private JCheckBox showAnnotationsInEditorCheckBox;
    private JCheckBox showDescriptionInTasksCheckBox;
    private JCheckBox showRuleInTasksCheckBox;
    private JCheckBox showRuleSetInTasksCheckBox;
    private JTextField sourceFileEncodingField;
    private JLabel sourceFileEncodingLabel;
    private JTextField suppressMarkerField;
    private JLabel suppressMarkerLabel;
    private JTextField targetJavaVersionField;
    private JLabel targetJavaVersionLabel;
    private JCheckBox useScanMessagesCacheCheckBox;
    private JButton verifySettingsButton;

    EasyPmdPanel() {
        this.initComponents();
        this.pathFilteringScrollPane.getVerticalScrollBar().setUnitIncrement(300);
        this.dialogService = Injector.lookup(DialogService.class);
        this.optionsFactory = Injector.lookup(OptionsFactory.class);
        this.profileComboActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EasyPmdPanel.this.refillingProfileCombo) {
                    return;
                }
                String selectedProfileName = (String)EasyPmdPanel.this.profileCombo.getSelectedItem();
                String oldProfileName = EasyPmdPanel.this.activeProfileName;
                EasyPmdPanel.this.activeProfileName = selectedProfileName;
                EasyPmdPanel.this.updateOptionsControls(oldProfileName);
            }
        };
    }

    private Options getOptions() {
        DefaultOptions result = new DefaultOptions();
        result.setTargetJavaVersion(this.targetJavaVersionField.getText());
        result.setSourceFileEncoding(this.sourceFileEncodingField.getText());
        result.setSuppressMarker(this.suppressMarkerField.getText());
        result.setAdditionalClassPathUrls(this.additionalClasspathPanel.getAdditionalClassPathUrls());
        result.setRuleSets(this.ruleSetsPanel.getRuleSets());
        result.setUseScanMessagesCache(this.useScanMessagesCacheCheckBox.isSelected());
        result.setShowDescriptionInTasks(this.showDescriptionInTasksCheckBox.isSelected());
        result.setShowRuleInTasks(this.showRuleInTasksCheckBox.isSelected());
        result.setShowRuleSetInTasks(this.showRuleSetInTasksCheckBox.isSelected());
        result.setShowAnnotationsInEditor(this.showAnnotationsInEditorCheckBox.isSelected());
        result.setShowAllMessagesInGuardedSections(this.showAllMessagesInGuardedSectionsCheckBox.isSelected());
        result.setPathFilteringOptions(new PathFilteringOptions((CompositeRegex)new OsSpecificPathCompositeRegex(this.pathFilteringPanel.getIncludedPathRegexes()), (CompositeRegex)new OsSpecificPathCompositeRegex(this.pathFilteringPanel.getExcludedPathRegexes())));
        return result;
    }

    synchronized ProfileConfiguration getProfileConfiguration() {
        this.updateOptionsInActiveProfile();
        return new DefaultProfileConfiguration(this.profiles, this.activeProfileName);
    }

    private void updateOptionsInActiveProfile() {
        Options activeOptions = this.getOptions();
        DefaultProfile activeProfile = new DefaultProfile(activeOptions);
        try {
            this.profiles.setProfile(this.activeProfileName, activeProfile);
        }
        catch (ProfileException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void refillProfileCombo() {
        this.refillingProfileCombo = true;
        try {
            this.profileCombo.removeAllItems();
            for (String profileName : this.profiles.getProfileNames()) {
                this.profileCombo.addItem(profileName);
            }
        }
        finally {
            this.refillingProfileCombo = false;
        }
    }

    private void updateProfileButtons() {
        this.removeProfileButton.setEnabled(this.profiles.getProfileNames().size() > 1);
    }

    private void updateOptionsControls(String oldProfileName) {
        if (this.activeProfileName.equals(oldProfileName)) {
            return;
        }
        if (this.profiles.profileNameExists(oldProfileName)) {
            Options oldProfileOptions = this.getOptions();
            DefaultProfile oldProfile = new DefaultProfile(oldProfileOptions);
            try {
                this.profiles.setProfile(oldProfileName, oldProfile);
            }
            catch (ProfileException ex) {
                throw new RuntimeException(ex);
            }
        }
        Profile activeProfile = this.profiles.getProfile(this.activeProfileName);
        this.setOptions(activeProfile.getOptions());
    }

    synchronized void setProfileConfiguration(ProfileConfiguration profileConfiguration) {
        this.activeProfileName = profileConfiguration.getActiveProfileName();
        this.profiles = profileConfiguration.getProfiles();
        this.profiles.addProfileNamesChangedListener(new TriggerListener(){

            public void onTriggered() {
                EasyPmdPanel.this.refillProfileCombo();
                EasyPmdPanel.this.updateProfileButtons();
            }
        });
        this.profileCombo.removeActionListener(this.profileComboActionListener);
        this.refillProfileCombo();
        this.updateProfileButtons();
        this.profileCombo.addActionListener(this.profileComboActionListener);
        this.profileCombo.setSelectedItem(this.activeProfileName);
        this.activeProfileName = profileConfiguration.getActiveProfileName();
        Options initialOptions = profileConfiguration.getActiveOptions();
        this.setOptions(initialOptions);
    }

    private void setOptions(Options options) {
        this.targetJavaVersionField.setText(options.getTargetJavaVersion());
        this.sourceFileEncodingField.setText(options.getSourceFileEncoding());
        this.suppressMarkerField.setText(options.getSuppressMarker());
        this.additionalClasspathPanel.setAdditionalClasspathUrls(options.getAdditionalClassPathUrls());
        this.ruleSetsPanel.setRuleSets(options.getRuleSets());
        this.useScanMessagesCacheCheckBox.setSelected(options.isUseScanMessagesCache());
        this.showDescriptionInTasksCheckBox.setSelected(options.isShowDescriptionInTasks());
        this.showRuleInTasksCheckBox.setSelected(options.isShowRuleInTasks());
        this.showRuleSetInTasksCheckBox.setSelected(options.isShowRuleSetInTasks());
        this.showAnnotationsInEditorCheckBox.setSelected(options.isShowAnnotationsInEditor());
        this.showAllMessagesInGuardedSectionsCheckBox.setSelected(options.isShowAllMessagesInGuardedSections());
        this.pathFilteringPanel.setIncludedPathRegexes(options.getPathFilteringOptions().getIncludedPathCompositeRegex().getSubRegexes());
        this.pathFilteringPanel.setExcludedPathRegexes(options.getPathFilteringOptions().getExcludedPathCompositeRegex().getSubRegexes());
    }

    private boolean clearScanMessagesScache() {
        return this.scanMessagesCache.clear();
    }

    private void verifyOptions() throws InvalidOptionsException {
        this.optionsService.verifyOptions(this.getOptions());
    }

    private void initComponents() {
        this.resetSettingsButton = new JButton();
        this.verifySettingsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.profileLabel = new JLabel();
        this.profileCombo = new JComboBox();
        this.duplicateProfileButton = new JButton();
        this.renameProfileButton = new JButton();
        this.removeProfileButton = new JButton();
        this.optionsTabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.targetJavaVersionLabel = new JLabel();
        this.targetJavaVersionField = new JTextField();
        this.sourceFileEncodingLabel = new JLabel();
        this.sourceFileEncodingField = new JTextField();
        this.suppressMarkerLabel = new JLabel();
        this.suppressMarkerField = new JTextField();
        this.mainAdditionalClasspathPanel = new JPanel();
        this.additionalClasspathPanel = new AdditionalClasspathPanel();
        this.mainRuleSetsPanel = new JPanel();
        this.ruleSetsPanel = new RuleSetsPanel();
        this.cachePanel = new JPanel();
        this.useScanMessagesCacheCheckBox = new JCheckBox();
        this.clearScanMessagesCacheButton = new JButton();
        this.reportingPanel = new JPanel();
        this.showDescriptionInTasksCheckBox = new JCheckBox();
        this.showRuleInTasksCheckBox = new JCheckBox();
        this.showRuleSetInTasksCheckBox = new JCheckBox();
        this.showAnnotationsInEditorCheckBox = new JCheckBox();
        this.showAllMessagesInGuardedSectionsCheckBox = new JCheckBox();
        this.mainPathFilteringPanel = new JPanel();
        this.pathFilteringScrollPane = new JScrollPane();
        this.pathFilteringPanel = new PathFilteringPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.resetSettingsButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.resetSettingsButton.text"));
        this.resetSettingsButton.setPreferredSize(new Dimension(101, 30));
        this.resetSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.resetSettingsButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.resetSettingsButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.verifySettingsButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.verifySettingsButton.text"));
        this.verifySettingsButton.setPreferredSize(new Dimension(101, 30));
        this.verifySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.verifySettingsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.verifySettingsButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.profileLabel, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.profileLabel.text"));
        this.jPanel1.add((Component)this.profileLabel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.profileCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateProfileButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.duplicateProfileButton.text"));
        this.duplicateProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.duplicateProfileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.duplicateProfileButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.renameProfileButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.renameProfileButton.text"));
        this.renameProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.renameProfileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.renameProfileButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeProfileButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.removeProfileButton.text"));
        this.removeProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.removeProfileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel1.add((Component)this.removeProfileButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.optionsTabbedPane.setPreferredSize(new Dimension(600, 300));
        this.generalPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.targetJavaVersionLabel, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.targetJavaVersionLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.targetJavaVersionLabel, gridBagConstraints);
        this.targetJavaVersionField.setText(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.sourceFileEncodingField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.targetJavaVersionField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.sourceFileEncodingLabel, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.sourceFileEncodingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.sourceFileEncodingLabel, gridBagConstraints);
        this.sourceFileEncodingField.setText(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.sourceFileEncodingField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.sourceFileEncodingField, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.suppressMarkerLabel, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.suppressMarkerLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.suppressMarkerLabel, gridBagConstraints);
        this.suppressMarkerField.setText(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.sourceFileEncodingField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.generalPanel.add((Component)this.suppressMarkerField, gridBagConstraints);
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.generalPanel.TabConstraints.tabTitle"), this.generalPanel);
        this.mainAdditionalClasspathPanel.setLayout(new BorderLayout());
        this.additionalClasspathPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.mainAdditionalClasspathPanel.add((Component)this.additionalClasspathPanel, "Center");
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.mainAdditionalClasspathPanel.TabConstraints.tabTitle"), this.mainAdditionalClasspathPanel);
        this.mainRuleSetsPanel.setLayout(new BorderLayout());
        this.ruleSetsPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.mainRuleSetsPanel.add((Component)this.ruleSetsPanel, "Center");
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.mainRuleSetsPanel.TabConstraints.tabTitle"), this.mainRuleSetsPanel);
        this.cachePanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.useScanMessagesCacheCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.useScanMessagesCacheCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.cachePanel.add((Component)this.useScanMessagesCacheCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.clearScanMessagesCacheButton, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.clearScanMessagesCacheButton.text"));
        this.clearScanMessagesCacheButton.setPreferredSize(new Dimension(107, 30));
        this.clearScanMessagesCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EasyPmdPanel.this.clearScanMessagesCacheButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.cachePanel.add((Component)this.clearScanMessagesCacheButton, gridBagConstraints);
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.cachePanel.TabConstraints.tabTitle"), this.cachePanel);
        this.reportingPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.showDescriptionInTasksCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.showDescriptionInTasksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.reportingPanel.add((Component)this.showDescriptionInTasksCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showRuleInTasksCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.showRuleInTasksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.reportingPanel.add((Component)this.showRuleInTasksCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showRuleSetInTasksCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.showRuleSetInTasksCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.reportingPanel.add((Component)this.showRuleSetInTasksCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showAnnotationsInEditorCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.showAnnotationsInEditorCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.reportingPanel.add((Component)this.showAnnotationsInEditorCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showAllMessagesInGuardedSectionsCheckBox, (String)NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.showAllMessagesInGuardedSectionsCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.reportingPanel.add((Component)this.showAllMessagesInGuardedSectionsCheckBox, gridBagConstraints);
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.reportingPanel.TabConstraints.tabTitle"), this.reportingPanel);
        this.mainPathFilteringPanel.setLayout(new BorderLayout());
        this.pathFilteringScrollPane.setHorizontalScrollBar(null);
        this.pathFilteringPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.pathFilteringScrollPane.setViewportView(this.pathFilteringPanel);
        this.mainPathFilteringPanel.add((Component)this.pathFilteringScrollPane, "Center");
        this.optionsTabbedPane.addTab(NbBundle.getMessage(EasyPmdPanel.class, (String)"EasyPmdPanel.mainPathFilteringPanel.TabConstraints.tabTitle"), this.mainPathFilteringPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.optionsTabbedPane, gridBagConstraints);
    }

    private void clearScanMessagesCacheButtonActionPerformed(ActionEvent evt) {
        if (this.clearScanMessagesScache()) {
            this.dialogService.showInfo("The cache has been correctly cleared");
        } else {
            this.dialogService.showWarning("The cache might have been only partially cleared");
        }
    }

    private void verifySettingsButtonActionPerformed(ActionEvent evt) {
        try {
            this.verifyOptions();
            this.dialogService.showInfo("Your EasyPmd options seem to be correct.");
        }
        catch (InvalidOptionsException ex) {
            this.dialogService.showWarning(String.format("The current EasyPmd options appear to be incorrect.\n%s", ex.getMessage()));
        }
    }

    private void resetSettingsButtonActionPerformed(ActionEvent evt) {
        Options defaultOptions = this.optionsFactory.createDefaultOptions();
        this.setOptions(defaultOptions);
        this.dialogService.showInfo("The default options have been restored in the dialog controls.\nTo save them, please confirm the options dialog.");
    }

    private void renameProfileButtonActionPerformed(ActionEvent evt) {
        String currentName = this.activeProfileName;
        String newName = this.dialogService.askForString("New profile name:", currentName);
        if (newName == null) {
            return;
        }
        try {
            this.updateOptionsInActiveProfile();
            this.profiles.renameProfile(currentName, newName);
        }
        catch (ProfileException ex) {
            this.dialogService.showWarning(ex.getMessage());
            return;
        }
        this.profileCombo.setSelectedItem(newName);
    }

    private void duplicateProfileButtonActionPerformed(ActionEvent evt) {
        String newName = this.dialogService.askForString("New profile name:");
        if (newName == null) {
            return;
        }
        String sourceName = this.activeProfileName;
        try {
            this.updateOptionsInActiveProfile();
            this.profiles.duplicateProfile(sourceName, newName);
        }
        catch (ProfileException ex) {
            this.dialogService.showWarning(ex.getMessage());
            return;
        }
        this.profileCombo.setSelectedItem(newName);
    }

    private void removeProfileButtonActionPerformed(ActionEvent evt) {
        if (this.dialogService.askYesNoQuestion("Do you really wish to delete the selected profile?") != CommonQuestionOutcome.YES) {
            return;
        }
        try {
            this.profiles.removeProfile(this.activeProfileName);
        }
        catch (ProfileException ex) {
            this.dialogService.showWarning(ex.getMessage());
            return;
        }
        this.profileCombo.setSelectedIndex(0);
    }
}

