/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options;

import info.gianlucacosta.easypmd4.PluginInfoService;
import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.pmdscanner.RuleSetWrapper;
import info.gianlucacosta.easypmd4.pmdscanner.StandardRuleSetsCatalog;
import info.gianlucacosta.helios.conversions.CollectionToArrayConverter;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionJList;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.pmd.RuleSet;
import org.openide.util.NbBundle;

public class RuleSetsPanel
extends JPanel {
    private static final CollectionToArrayConverter<RuleSetWrapper> rulesetsArrayConverter = new CollectionToArrayConverter(RuleSetWrapper.class);
    private final AdvancedSelectionListModel<String> ruleSetsModel = new AdvancedSelectionListModel();
    private final DialogService dialogService;
    private final PluginInfoService pluginInfoService;
    private final StandardRuleSetsCatalog standardRulesetsCatalog;
    private JButton addCustomRuleSetButton;
    private JButton addStandardRuleSetButton;
    private JPanel buttonsPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private AdvancedSelectionJList ruleSetsList;
    private JScrollPane ruleSetsScrollPane;

    public RuleSetsPanel() {
        this.initComponents();
        this.dialogService = Injector.lookup(DialogService.class);
        this.pluginInfoService = Injector.lookup(PluginInfoService.class);
        this.standardRulesetsCatalog = Injector.lookup(StandardRuleSetsCatalog.class);
        this.ruleSetsList.setModel(this.ruleSetsModel);
    }

    private void initComponents() {
        this.ruleSetsScrollPane = new JScrollPane();
        this.ruleSetsList = new AdvancedSelectionJList();
        this.buttonsPanel = new JPanel();
        this.addStandardRuleSetButton = new JButton();
        this.addCustomRuleSetButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.ruleSetsScrollPane.setViewportView((Component)this.ruleSetsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.ruleSetsScrollPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.addStandardRuleSetButton.setText(NbBundle.getMessage(RuleSetsPanel.class, (String)"RuleSetsPanel.addStandardRuleSetButton.text"));
        this.addStandardRuleSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleSetsPanel.this.addStandardRuleSetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.addStandardRuleSetButton, gridBagConstraints);
        this.addCustomRuleSetButton.setText(NbBundle.getMessage(RuleSetsPanel.class, (String)"RuleSetsPanel.addCustomRuleSetButton.text"));
        this.addCustomRuleSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleSetsPanel.this.addCustomRuleSetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.addCustomRuleSetButton, gridBagConstraints);
        this.moveUpButton.setText(NbBundle.getMessage(RuleSetsPanel.class, (String)"RuleSetsPanel.moveUpButton.text"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleSetsPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setText(NbBundle.getMessage(RuleSetsPanel.class, (String)"RuleSetsPanel.moveDownButton.text"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleSetsPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getMessage(RuleSetsPanel.class, (String)"RuleSetsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleSetsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void addStandardRuleSetButtonActionPerformed(ActionEvent evt) {
        Collection<RuleSetWrapper> standardRuleSetWrappers = this.standardRulesetsCatalog.getRuleSetWrappers();
        Object userChoice = JOptionPane.showInputDialog(null, "Choose a standard rule set:", this.pluginInfoService.getName(), -1, null, rulesetsArrayConverter.convert(standardRuleSetWrappers), null);
        if (userChoice == null) {
            return;
        }
        RuleSet chosenRuleSet = ((RuleSetWrapper)userChoice).getRuleSet();
        this.ruleSetsModel.addElement((Object)chosenRuleSet.getFileName());
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.ruleSetsList.removeSelection();
    }

    private void addCustomRuleSetButtonActionPerformed(ActionEvent evt) {
        String newRuleSet = this.dialogService.askForString("Rule set:");
        if (newRuleSet == null) {
            return;
        }
        if ((newRuleSet = newRuleSet.trim()).isEmpty()) {
            this.dialogService.showWarning("Invalid rule set");
        }
        this.ruleSetsModel.addElement((Object)newRuleSet);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.ruleSetsList.moveUpSelection();
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.ruleSetsList.moveDownSelection();
    }

    public Collection<String> getRuleSets() {
        return this.ruleSetsModel.getItems();
    }

    public void setRuleSets(Collection<String> ruleSets) {
        this.ruleSetsModel.setItems(ruleSets);
    }
}

