/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options.profiles;

import info.gianlucacosta.easypmd4.StorageAreaService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.profiles.DefaultProfileConfigurationFactory;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfiguration;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfigurationFactory;
import info.gianlucacosta.easypmd4.ide.options.profiles.ProfileConfigurationRepository;
import info.gianlucacosta.easypmd4.io.StreamUtils;
import info.gianlucacosta.helios.io.storagearea.StorageArea;
import info.gianlucacosta.helios.io.storagearea.StorageAreaEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProfileConfigurationRepository
implements ProfileConfigurationRepository {
    private static final String PROFILE_CONFIGURATION_ENTRY_NAME = "ProfileConfiguration";
    private static final Logger logger = Logger.getLogger(DefaultProfileConfigurationFactory.class.getName());
    private final StorageArea storageArea;
    private final ProfileConfigurationFactory profileConfigurationFactory = Injector.lookup(ProfileConfigurationFactory.class);
    private ProfileConfiguration profileConfiguration;

    public DefaultProfileConfigurationRepository() {
        StorageAreaService storageAreaService = Injector.lookup(StorageAreaService.class);
        this.storageArea = storageAreaService.getStorageArea();
        if (this.storageArea != null) {
            block16: {
                try {
                    StorageAreaEntry profileConfigurationEntry = this.storageArea.getEntry(new String[]{PROFILE_CONFIGURATION_ENTRY_NAME});
                    if (!profileConfigurationEntry.exists()) break block16;
                    try (InputStream profileConfigurationInputStream = profileConfigurationEntry.openInputStream();){
                        this.profileConfiguration = (ProfileConfiguration)StreamUtils.readSingleObjectFromStream(profileConfigurationInputStream);
                    }
                }
                catch (IOException | ClassNotFoundException ex) {
                    logger.log(Level.SEVERE, "Exception while loading the options", ex);
                }
            }
            if (this.profileConfiguration == null) {
                this.profileConfiguration = this.profileConfigurationFactory.createDefaultProfileConfiguration();
            }
        }
    }

    @Override
    public synchronized ProfileConfiguration getProfileConfiguration() {
        return this.profileConfiguration;
    }

    @Override
    public synchronized void saveProfileConfiguration(ProfileConfiguration profileConfiguration) {
        this.profileConfiguration = profileConfiguration;
        if (this.storageArea != null) {
            try {
                StorageAreaEntry profileConfigurationEntry = this.storageArea.getEntry(new String[]{PROFILE_CONFIGURATION_ENTRY_NAME});
                try (OutputStream profileConfigurationOutputStream = profileConfigurationEntry.openOutputStream();){
                    StreamUtils.writeSingleObjectToStream(profileConfigurationOutputStream, profileConfiguration);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving the options", ex);
            }
        }
    }
}

