/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.ide.options.regexes;

import info.gianlucacosta.easypmd4.ide.DialogService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.regexes.RegexTemplate;
import info.gianlucacosta.easypmd4.ide.options.regexes.RegexTemplateSelectionDialog;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionJList;
import info.gianlucacosta.helios.swing.jlist.AdvancedSelectionListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.NbBundle;

public class RegexesPanel
extends JPanel {
    private final AdvancedSelectionListModel<String> regexesModel = new AdvancedSelectionListModel();
    private final DialogService dialogService;
    private final RegexTemplateSelectionDialog regexTemplateSelectionDialog;
    private JButton addCustomPathButton;
    private JButton addPredefinedPathButton;
    private JPanel includedPathsButtonsPanel;
    private JButton moveDownPathButton;
    private JButton moveUpPathButton;
    private AdvancedSelectionJList regexesList;
    private JScrollPane regexesScrollPane;
    private JButton removePathButton;

    public RegexesPanel() {
        this.initComponents();
        this.dialogService = Injector.lookup(DialogService.class);
        this.regexTemplateSelectionDialog = Injector.lookup(RegexTemplateSelectionDialog.class);
        this.regexesList.setModel(this.regexesModel);
    }

    public Collection<String> getRegexes() {
        return this.regexesModel.getItems();
    }

    public void setRegexes(Collection<String> regexes) {
        this.regexesModel.setItems(regexes);
    }

    private String processInputRegex(String regex) {
        regex = regex.trim();
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException ex) {
            this.dialogService.showWarning("Invalid regular expression");
            return null;
        }
        return regex;
    }

    private void initComponents() {
        this.regexesScrollPane = new JScrollPane();
        this.regexesList = new AdvancedSelectionJList();
        this.includedPathsButtonsPanel = new JPanel();
        this.addPredefinedPathButton = new JButton();
        this.addCustomPathButton = new JButton();
        this.moveUpPathButton = new JButton();
        this.moveDownPathButton = new JButton();
        this.removePathButton = new JButton();
        this.setLayout(new BorderLayout());
        this.regexesScrollPane.setViewportView((Component)this.regexesList);
        this.add((Component)this.regexesScrollPane, "Center");
        this.includedPathsButtonsPanel.setLayout(new GridBagLayout());
        this.addPredefinedPathButton.setText(NbBundle.getMessage(RegexesPanel.class, (String)"RegexesPanel.addPredefinedPathButton.text"));
        this.addPredefinedPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexesPanel.this.addPredefinedPathButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.includedPathsButtonsPanel.add((Component)this.addPredefinedPathButton, gridBagConstraints);
        this.addCustomPathButton.setText(NbBundle.getMessage(RegexesPanel.class, (String)"RegexesPanel.addCustomPathButton.text"));
        this.addCustomPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexesPanel.this.addCustomPathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.includedPathsButtonsPanel.add((Component)this.addCustomPathButton, gridBagConstraints);
        this.moveUpPathButton.setText(NbBundle.getMessage(RegexesPanel.class, (String)"RegexesPanel.moveUpPathButton.text"));
        this.moveUpPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexesPanel.this.moveUpPathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.includedPathsButtonsPanel.add((Component)this.moveUpPathButton, gridBagConstraints);
        this.moveDownPathButton.setText(NbBundle.getMessage(RegexesPanel.class, (String)"RegexesPanel.moveDownPathButton.text"));
        this.moveDownPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexesPanel.this.moveDownPathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.includedPathsButtonsPanel.add((Component)this.moveDownPathButton, gridBagConstraints);
        this.removePathButton.setText(NbBundle.getMessage(RegexesPanel.class, (String)"RegexesPanel.removePathButton.text"));
        this.removePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegexesPanel.this.removePathButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.includedPathsButtonsPanel.add((Component)this.removePathButton, gridBagConstraints);
        this.add((Component)this.includedPathsButtonsPanel, "After");
    }

    private void addPredefinedPathButtonActionPerformed(ActionEvent evt) {
        String newPathRegex;
        do {
            RegexTemplate regexTemplate;
            if ((regexTemplate = this.regexTemplateSelectionDialog.askForRegexTemplate()) == null) {
                return;
            }
            newPathRegex = regexTemplate.getRegex();
            if (newPathRegex != null) continue;
            return;
        } while ((newPathRegex = this.processInputRegex(newPathRegex)) == null || newPathRegex.isEmpty());
        this.regexesModel.addElement((Object)newPathRegex);
    }

    private void addCustomPathButtonActionPerformed(ActionEvent evt) {
        String newPathRegex;
        do {
            if ((newPathRegex = this.dialogService.askForString("Regular expression:")) != null) continue;
            return;
        } while ((newPathRegex = this.processInputRegex(newPathRegex)) == null || newPathRegex.isEmpty());
        this.regexesModel.addElement((Object)newPathRegex);
    }

    private void moveUpPathButtonActionPerformed(ActionEvent evt) {
        this.regexesList.moveUpSelection();
    }

    private void moveDownPathButtonActionPerformed(ActionEvent evt) {
        this.regexesList.moveDownSelection();
    }

    private void removePathButtonActionPerformed(ActionEvent evt) {
        this.regexesList.removeSelection();
    }
}

