/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.easypmd4.pmdscanner.RuleSetWrapper;
import info.gianlucacosta.easypmd4.pmdscanner.StandardRuleSetsCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;

public class DefaultStandardRuleSetsCatalog
implements StandardRuleSetsCatalog {
    private final List<RuleSetWrapper> wrappers = new ArrayList<RuleSetWrapper>();

    public DefaultStandardRuleSetsCatalog() {
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        try {
            Iterator ruleSetsIterator = ruleSetFactory.getRegisteredRuleSets();
            while (ruleSetsIterator.hasNext()) {
                RuleSet ruleSet = (RuleSet)ruleSetsIterator.next();
                this.wrappers.add(new RuleSetWrapper(ruleSet));
            }
        }
        catch (RuleSetNotFoundException ex) {
            throw new RuntimeException("Error while initializing the list of PMD's standard rule sets", ex);
        }
    }

    @Override
    public Collection<RuleSetWrapper> getRuleSetWrappers() {
        return Collections.unmodifiableCollection(this.wrappers);
    }

    @Override
    public boolean containsFileName(String ruleSetFileName) {
        for (RuleSetWrapper wrapper : this.wrappers) {
            RuleSet ruleSet = wrapper.getRuleSet();
            if (!ruleSet.getFileName().equals(ruleSetFileName)) continue;
            return true;
        }
        return false;
    }
}

