/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner;

import info.gianlucacosta.helios.conversions.CollectionToArrayConverter;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import net.sourceforge.pmd.PMD;

class PmdBasedClassLoader
extends URLClassLoader {
    private static final CollectionToArrayConverter<URL> urlsToArrayConverter = new CollectionToArrayConverter(URL.class);
    private final ClassLoader pmdClassLoader = PMD.class.getClassLoader();

    public PmdBasedClassLoader(Collection<URL> additionalUrls) {
        super((URL[])urlsToArrayConverter.convert(additionalUrls));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> classLoadedByPmdClassLoader = this.pmdClassLoader.loadClass(name);
        if (classLoadedByPmdClassLoader != null) {
            return classLoadedByPmdClassLoader;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream streamReadByPmdClassLoader = this.pmdClassLoader.getResourceAsStream(name);
        if (streamReadByPmdClassLoader != null) {
            return streamReadByPmdClassLoader;
        }
        return super.getResourceAsStream(name);
    }
}

