/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner.messagescache;

import info.gianlucacosta.easypmd4.pmdscanner.ScanMessageList;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.ScanMessagesCache;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.ScanMessagesCacheItem;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class AbstractScanMessagesCache
implements ScanMessagesCache {
    private final Lock readLock;
    private final Lock writeLock;

    public AbstractScanMessagesCache() {
        ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
        this.readLock = cacheLock.readLock();
        this.writeLock = cacheLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanMessageList getScanMessagesFor(File file) {
        this.readLock.lock();
        try {
            ScanMessagesCacheItem cacheItem = this.getItem(file);
            if (cacheItem == null) {
                ScanMessageList scanMessageList = null;
                return scanMessageList;
            }
            if (!cacheItem.isSynchronizedWith(file)) {
                ScanMessageList scanMessageList = null;
                return scanMessageList;
            }
            ScanMessageList scanMessageList = cacheItem.getScanMessages();
            return scanMessageList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putScanMessagesFor(File file, ScanMessageList scanMessages) {
        this.writeLock.lock();
        try {
            ScanMessagesCacheItem cacheItem = new ScanMessagesCacheItem(file, scanMessages);
            this.putItem(file, cacheItem);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean clear() {
        this.writeLock.lock();
        try {
            boolean bl = this.doClear();
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract ScanMessagesCacheItem getItem(File var1);

    protected abstract void putItem(File var1, ScanMessagesCacheItem var2);

    protected abstract boolean doClear();
}

