/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner.messagescache;

import info.gianlucacosta.easypmd4.StorageAreaService;
import info.gianlucacosta.easypmd4.ide.Injector;
import info.gianlucacosta.easypmd4.ide.options.OptionsService;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.AbstractScanMessagesCache;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.InMemoryScanMessagesCache;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.ScanMessagesCacheItem;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.StorageAreaBasedScanMessagesCache;
import info.gianlucacosta.helios.beans.events.TriggerListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScanMessagesCacheFacade
extends AbstractScanMessagesCache {
    private static final Logger logger = Logger.getLogger(AbstractScanMessagesCache.class.getName());
    private final OptionsService optionsService;
    private final InMemoryScanMessagesCache inMemoryCache = new InMemoryScanMessagesCache();
    private final StorageAreaBasedScanMessagesCache onDiskCache;

    public ScanMessagesCacheFacade() {
        this.optionsService = Injector.lookup(OptionsService.class);
        StorageAreaService storageAreaService = Injector.lookup(StorageAreaService.class);
        this.onDiskCache = new StorageAreaBasedScanMessagesCache(storageAreaService.getStorageArea());
        this.optionsService.addOptionsChangedListener(new TriggerListener(){

            public void onTriggered() {
                logger.log(Level.INFO, "The options have changed: clearing the cache");
                ScanMessagesCacheFacade.this.clear();
            }
        });
    }

    @Override
    protected ScanMessagesCacheItem getItem(File file) {
        ScanMessagesCacheItem memoryCacheItem = this.inMemoryCache.getItem(file);
        if (memoryCacheItem != null) {
            return memoryCacheItem;
        }
        ScanMessagesCacheItem storageCacheItem = this.onDiskCache.getItem(file);
        if (storageCacheItem != null) {
            this.inMemoryCache.putItem(file, storageCacheItem);
            return storageCacheItem;
        }
        return null;
    }

    @Override
    protected void putItem(File file, ScanMessagesCacheItem cacheItem) {
        this.inMemoryCache.putItem(file, cacheItem);
        this.onDiskCache.putItem(file, cacheItem);
    }

    @Override
    protected boolean doClear() {
        return this.inMemoryCache.clear() && this.onDiskCache.clear();
    }
}

