/*
 * Decompiled with CFR 0.152.
 */
package info.gianlucacosta.easypmd4.pmdscanner.messagescache;

import info.gianlucacosta.easypmd4.io.StreamUtils;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.AbstractScanMessagesCache;
import info.gianlucacosta.easypmd4.pmdscanner.messagescache.ScanMessagesCacheItem;
import info.gianlucacosta.helios.io.storagearea.StorageArea;
import info.gianlucacosta.helios.io.storagearea.StorageAreaEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class StorageAreaBasedScanMessagesCache
extends AbstractScanMessagesCache {
    private static final Logger logger = Logger.getLogger(StorageAreaBasedScanMessagesCache.class.getName());
    private static final String ROOT_CACHE_ENTRY = "cache";
    private final StorageArea storageArea;

    public StorageAreaBasedScanMessagesCache(StorageArea storageArea) {
        this.storageArea = storageArea;
    }

    @Override
    protected ScanMessagesCacheItem getItem(File scannedFile) {
        if (this.storageArea == null) {
            logger.log(Level.FINE, "No storage area detected - reading cannot be performed");
            return null;
        }
        Map<String, ScanMessagesCacheItem> clusterMap = this.getClusterMap(scannedFile);
        if (clusterMap == null) {
            return null;
        }
        return clusterMap.get(scannedFile.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ScanMessagesCacheItem> getClusterMap(File scannedFile) {
        try {
            StorageAreaEntry clusterMapEntry = this.getClusterMapEntry(scannedFile);
            if (!clusterMapEntry.exists()) {
                return null;
            }
            try (InputStream entryStream = clusterMapEntry.openInputStream();){
                Map map = (Map)StreamUtils.readSingleObjectFromStream(entryStream);
                return map;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            logger.log(Level.WARNING, String.format("Error while reading cache cluster map for file: '%s'", scannedFile.getAbsolutePath()), ex);
            return null;
        }
    }

    private StorageAreaEntry getClusterMapEntry(File scannedFile) throws IOException {
        String absolutePath = scannedFile.getAbsolutePath();
        Integer pathHashCode = absolutePath.hashCode();
        return this.storageArea.getEntry(new String[]{ROOT_CACHE_ENTRY, pathHashCode.toString()});
    }

    @Override
    protected void putItem(File scannedFile, ScanMessagesCacheItem cacheItem) {
        if (this.storageArea == null) {
            logger.log(Level.FINE, "No storage area detected - bypassing writing phase...");
            return;
        }
        Map<String, ScanMessagesCacheItem> clusterMap = this.getClusterMap(scannedFile);
        if (clusterMap == null) {
            clusterMap = new HashMap<String, ScanMessagesCacheItem>();
        }
        clusterMap.put(scannedFile.getAbsolutePath(), cacheItem);
        try {
            StorageAreaEntry clusterMapEntry = this.getClusterMapEntry(scannedFile);
            try (OutputStream entryOutputStream = clusterMapEntry.openOutputStream();){
                StreamUtils.writeSingleObjectToStream(entryOutputStream, clusterMap);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, String.format("Error while writing the cache cluster map for file: '%s'", scannedFile.getAbsolutePath()), ex);
        }
    }

    @Override
    protected boolean doClear() {
        if (this.storageArea == null) {
            logger.log(Level.FINE, "No storage area detected - the cache is already empty");
            return true;
        }
        try {
            StorageAreaEntry rootCacheEntry = this.storageArea.getEntry(new String[]{ROOT_CACHE_ENTRY});
            rootCacheEntry.remove();
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not clear the cache", ex);
            return false;
        }
    }
}

