%define rubyver         2.2.2

Name:           ruby
Version:        %{rubyver}
Release:        1%{?dist}
License:        Ruby License/GPL - see COPYING
URL:            http://www.ruby-lang.org/
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  readline libyaml libyaml-devel readline-devel ncurses ncurses-devel gdbm gdbm-devel glibc-devel tcl-devel gcc unzip openssl-devel db4-devel byacc make libffi-devel
Requires:       coreutils db4 gdbm glibc libffi libyaml ncurses-libs pkgconfig openssl readline zlib
Source0:        ftp://ftp.ruby-lang.org/pub/ruby/ruby-%{rubyver}.tar.bz2
Summary:        An interpreter of object-oriented scripting language
Group:          Development/Languages
Provides: ruby(abi) = 2.2
Provides: ruby-irb
Provides: ruby-rdoc
Provides: ruby-libs
Provides: ruby-devel
Provides: rubygems
Obsoletes: ruby-libs
Obsoletes: ruby-irb
Obsoletes: ruby-rdoc
Obsoletes: ruby-devel
Obsoletes: rubygems

%description
Ruby is the interpreted scripting language for quick and easy
object-oriented programming.  It has many features to process text
files and to do system management tasks (as in Perl).  It is simple,
straight-forward, and extensible.

%prep
%setup -n ruby-%{rubyver}

%build
export CFLAGS="$RPM_OPT_FLAGS -Wall -fno-strict-aliasing"

%configure \
  --enable-shared \
  --disable-rpath \
  --without-X11 \
  --without-tk \
  --includedir=%{_includedir}/ruby \
  --libdir=%{_libdir}

make %{?_smp_mflags}

%install
# installing binaries ...
make install DESTDIR=$RPM_BUILD_ROOT

#we don't want to keep the src directory
rm -rf $RPM_BUILD_ROOT/usr/src

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%{_bindir}
%{_includedir}
%{_datadir}
%{_libdir}

%changelog
* Tue May  5 2015 Toru Takahashi <torutk@gmail.com> - 2.2.2
- Update for Ruby 2.2.2 release.
* Thu Mar  5 2015 Toru Takahashi <torutk@gmail.com> - 2.2.1
- remove Obsoletes ruby
* Fri Jan 30 2015 Toru Takahashi <torutk@gmail.com> - 2.2.0-1
- remove Obsoletes ruby
* Fri Jan  9 2015 Toru Takahashi <torutk@gmail.com> - 2.2.0
- Version bumped to 2.2.0
* Wed Nov 26 2014 Toru Takahashi <torutk@gmail.com> - 2.1.5
- Update for Ruby 2.1.5 release.
* Tue Oct 28 2014 Toru Takahashi <torutk@gmail.com> - 2.1.4
- Update for Ruby 2.1.4 release.
* Thu Oct 23 2014 Toru Takahashi <torutk@gmail.com> - 2.1.3
- Update for Ruby 2.1.3 release.
* Mon Jun 09 2014 Toru Takahashi <torutk@gmail.com> - 2.1.2
- Update for Ruby 2.1.2 release.
* Wed Feb 26 2014 Toru Takahashi <torutk@gmail.com> - 2.1.1
- Update for Ruby 2.1.1 release.
- Fix versioning after 2.1.0
* Fri Feb 14 2014 Toru Takahashi <torutk@gmail.com> - 2.1.0-p0
- Update for Ruby 2.1.0-p0 release.
* Mon Jul 01 2013 Toru Takahashi <torutk@gmail.com> - 2.0.0-p247
- Update for Ruby 2.0.0-p247 release.
* Mon Jun 10 2013 Toru Takahashi <torutk@gmail.com> - 2.0.0-p195
- Update for Ruby 2.0.0-p195 release.
* Tue Mar 19 2013 Toru Takahashi <torutk@gmail.com> - 1.9.3-p392
- Update for Ruby 1.9.3-p392 release.
* Thu Feb 14 2013 Martin Bokman <martin@bokman.org> - 1.9.3-p385
- Update for Ruby 1.9.3-p385 release.
* Tue Feb 5 2013 Ian Meyer <ianmmeyer@gmail.com> - 1.9.3-p374
- Update for Ruby 1.9.3-p327 release.
* Sun Nov 25 2012 Gareth Jones <me@gazj.co.uk> - 1.9.3-p327
- Update for Ruby 1.9.3-p327 release.
* Wed Apr 25 2012 mathew <meta@pobox.com> - 1.9.3-p194-1
- Update for Ruby 1.9.3-p194 release.
* Sat Feb 24 2012 Ian Meyer <ianmmeyer@gmail.com> - 1.9.3-p125-1
- Spec to replace system ruby with 1.9.3-p125
