/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.DataStreamEOFException;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.util.ISUtil;

public class ShapeHeader {
    private int recordNumber;
    private int contentLength;

    public ShapeHeader(InputStream is, ValidationPreferences rules) throws DataStreamEOFException, IOException, InvalidShapeFileException {
        this.recordNumber = ISUtil.readBeIntMaybeEOF(is);
        if (!rules.isAllowBadRecordNumbers() && this.recordNumber != rules.getExpectedRecordNumber()) {
            throw new InvalidShapeFileException("Invalid record number. Expected " + rules.getExpectedRecordNumber() + " but found " + this.recordNumber + ".");
        }
        this.contentLength = ISUtil.readBeInt(is);
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getContentLength() {
        return this.contentLength;
    }
}

