/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractMultiPointShape;
import org.nocrala.tools.gis.data.esri.shapefile.util.ISUtil;

public class MultiPointZShape
extends AbstractMultiPointShape {
    private static final int BASE_CONTENT_LENGTH = 36;
    private double minZ;
    private double maxZ;
    private double[] z;
    private double minM;
    private double maxM;
    private double[] m;

    public MultiPointZShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        int i;
        if (!rules.isAllowBadContentLength()) {
            int expectedLength = 36 + this.numberOfPoints * 32 / 2;
            if (this.header.getContentLength() != expectedLength) {
                throw new InvalidShapeFileException("Invalid " + this.getShapeTypeName() + " shape header's content length. " + "Expected " + expectedLength + " 16-bit words (for " + this.numberOfPoints + " points)" + " but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
            }
        }
        this.minZ = ISUtil.readLeDouble(is);
        this.maxZ = ISUtil.readLeDouble(is);
        this.z = new double[this.numberOfPoints];
        for (i = 0; i < this.numberOfPoints; ++i) {
            this.z[i] = ISUtil.readLeDouble(is);
        }
        this.minM = ISUtil.readLeDouble(is);
        this.maxM = ISUtil.readLeDouble(is);
        this.m = new double[this.numberOfPoints];
        for (i = 0; i < this.numberOfPoints; ++i) {
            this.m[i] = ISUtil.readLeDouble(is);
        }
    }

    protected String getShapeTypeName() {
        return "MultiPointZ";
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double[] getZ() {
        return this.z;
    }

    public double getMinM() {
        return this.minM;
    }

    public double getMaxM() {
        return this.maxM;
    }

    public double[] getM() {
        return this.m;
    }
}

