/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.shape.shapes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.nocrala.tools.gis.data.esri.shapefile.ValidationPreferences;
import org.nocrala.tools.gis.data.esri.shapefile.exception.InvalidShapeFileException;
import org.nocrala.tools.gis.data.esri.shapefile.shape.Const;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeHeader;
import org.nocrala.tools.gis.data.esri.shapefile.shape.ShapeType;
import org.nocrala.tools.gis.data.esri.shapefile.shape.shapes.AbstractPolyShape;
import org.nocrala.tools.gis.data.esri.shapefile.util.ISUtil;

public abstract class AbstractPolyZShape
extends AbstractPolyShape {
    private static final int BASE_CONTENT_LENGTH = 38;
    private double minZ;
    private double maxZ;
    private double[] z;
    private double minM;
    private double maxM;
    private double[] measures;

    public AbstractPolyZShape(ShapeHeader shapeHeader, ShapeType shapeType, InputStream is, ValidationPreferences rules) throws IOException, InvalidShapeFileException {
        super(shapeHeader, shapeType, is, rules);
        int i;
        if (!rules.isAllowBadContentLength()) {
            int expectedLength = 38 + this.numberOfParts * 4 / 2 + this.numberOfPoints * 32 / 2;
            if (this.header.getContentLength() != expectedLength) {
                throw new InvalidShapeFileException("Invalid " + this.getShapeTypeName() + " shape header's content length. " + "Expected " + expectedLength + " 16-bit words (for " + this.numberOfParts + " parts and " + this.numberOfPoints + " points)" + " but found " + this.header.getContentLength() + ". " + Const.PREFERENCES);
            }
        }
        this.minZ = ISUtil.readLeDouble(is);
        this.maxZ = ISUtil.readLeDouble(is);
        this.z = new double[this.numberOfPoints];
        for (i = 0; i < this.numberOfPoints; ++i) {
            this.z[i] = ISUtil.readLeDouble(is);
        }
        this.minM = ISUtil.readLeDouble(is);
        this.maxM = ISUtil.readLeDouble(is);
        this.measures = new double[this.numberOfPoints];
        for (i = 0; i < this.numberOfPoints; ++i) {
            this.measures[i] = ISUtil.readLeDouble(is);
        }
    }

    public double[] getMOfPart(int i) {
        int to;
        if (i < 0 || i >= this.numberOfParts) {
            throw new RuntimeException("Invalid part " + i + ". Available parts [0:" + this.numberOfParts + "].");
        }
        int from = this.partFirstPoints[i];
        int n = to = i < this.numberOfParts - 1 ? this.partFirstPoints[i + 1] : this.points.length;
        if (from < 0 || from > this.points.length) {
            throw new RuntimeException("Malformed content. Part start (" + from + ") is out of range. Valid range of points is [0:" + this.points.length + "].");
        }
        if (to < 0 || to > this.points.length) {
            throw new RuntimeException("Malformed content. Part end (" + to + ") is out of range. Valid range of points is [0:" + this.points.length + "].");
        }
        return Arrays.copyOfRange(this.measures, from, to);
    }

    public double[] getZOfPart(int i) {
        int to;
        if (i < 0 || i >= this.numberOfParts) {
            throw new RuntimeException("Invalid part " + i + ". Available parts [0:" + this.numberOfParts + "].");
        }
        int from = this.partFirstPoints[i];
        int n = to = i < this.numberOfParts - 1 ? this.partFirstPoints[i + 1] : this.points.length;
        if (from < 0 || from > this.points.length) {
            throw new RuntimeException("Malformed content. Part start (" + from + ") is out of range. Valid range of points is [0:" + this.points.length + "].");
        }
        if (to < 0 || to > this.points.length) {
            throw new RuntimeException("Malformed content. Part end (" + to + ") is out of range. Valid range of points is [0:" + this.points.length + "].");
        }
        return Arrays.copyOfRange(this.z, from, to);
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double[] getZ() {
        return this.z;
    }

    public double getMinM() {
        return this.minM;
    }

    public double getMaxM() {
        return this.maxM;
    }

    public double[] getMeasures() {
        return this.measures;
    }
}

