/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.gis.data.esri.shapefile.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.nocrala.tools.gis.data.esri.shapefile.exception.DataStreamEOFException;
import org.nocrala.tools.gis.data.esri.shapefile.util.DoubleSerializer;
import org.nocrala.tools.gis.data.esri.shapefile.util.IntSerializer;

public class ISUtil {
    private static final byte[] BUFFER = new byte[8];
    private static final ByteBuffer BYTE_BUFFER = ByteBuffer.wrap(BUFFER);

    public static synchronized int readBeIntMaybeEOF(InputStream is) throws DataStreamEOFException, IOException {
        ISUtil.readIntoBufferMaybeEOF(is, 4);
        return IntSerializer.deserializeBigEndian(BYTE_BUFFER);
    }

    public static synchronized int readBeInt(InputStream is) throws IOException {
        ISUtil.readIntoBuffer(is, 4);
        return IntSerializer.deserializeBigEndian(BYTE_BUFFER);
    }

    public static synchronized double readBeDoubleMaybeEOF(InputStream is) throws DataStreamEOFException, IOException {
        ISUtil.readIntoBufferMaybeEOF(is, 8);
        return DoubleSerializer.deserializeBigEndian(BYTE_BUFFER);
    }

    public static synchronized double readBeDouble(InputStream is) throws IOException {
        ISUtil.readIntoBuffer(is, 8);
        return DoubleSerializer.deserializeBigEndian(BYTE_BUFFER);
    }

    public static synchronized int readLeIntMaybeEOF(InputStream is) throws DataStreamEOFException, IOException {
        ISUtil.readIntoBufferMaybeEOF(is, 4);
        return IntSerializer.deserializeLittleEndian(BYTE_BUFFER);
    }

    public static synchronized int readLeInt(InputStream is) throws IOException {
        ISUtil.readIntoBuffer(is, 4);
        return IntSerializer.deserializeLittleEndian(BYTE_BUFFER);
    }

    public static synchronized double readLeDoubleMaybeEOF(InputStream is) throws DataStreamEOFException, IOException {
        ISUtil.readIntoBufferMaybeEOF(is, 8);
        return DoubleSerializer.deserializeLittleEndian(BYTE_BUFFER);
    }

    public static synchronized double readLeDouble(InputStream is) throws IOException {
        ISUtil.readIntoBuffer(is, 8);
        return DoubleSerializer.deserializeLittleEndian(BYTE_BUFFER);
    }

    private static void readIntoBufferMaybeEOF(InputStream is, int length) throws DataStreamEOFException, IOException {
        try {
            int read = is.read(BUFFER, 0, length);
            if (read != length) {
                throw new DataStreamEOFException();
            }
        }
        catch (EOFException e) {
            throw new DataStreamEOFException();
        }
    }

    private static void readIntoBuffer(InputStream is, int length) throws IOException {
        int read = is.read(BUFFER, 0, length);
        if (read != length) {
            throw new EOFException();
        }
    }
}

